/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.epl.UIEplPlugin;
import com.aptana.ui.preferences.EplMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class GenericRootPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected static HashMap<String, String> pageNameToId;
    protected static final String DEFAULT_MESSAGE;

    static {
        DEFAULT_MESSAGE = EplMessages.GenericRootPage_genericPerferencesPageMessage;
    }

    public GenericRootPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        if (pageNameToId == null) {
            pageNameToId = new HashMap();
            String pageId = this.getPageId();
            PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
            List nodes = manager.getElements(1);
            for (IPreferenceNode node : nodes) {
                IPreferenceNode[] subNodes;
                if (!node.getId().equals(pageId)) continue;
                IPreferenceNode[] iPreferenceNodeArray = subNodes = node.getSubNodes();
                int n = subNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    IPreferenceNode child = iPreferenceNodeArray[n2];
                    pageNameToId.put(child.getLabelText(), child.getId());
                    ++n2;
                }
                break block0;
            }
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        String contentsMessage = this.getContentsMessage();
        if (contentsMessage != null) {
            Label message = new Label(composite, 64);
            message.setText(contentsMessage);
        }
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(EplMessages.GenericRootPage_preferences);
        ArrayList<String> pagesNames = new ArrayList<String>(pageNameToId.keySet());
        if (pagesNames.isEmpty()) {
            Label label = new Label((Composite)group, 0);
            label.setText(EplMessages.GenericRootPage_noAvailablePages);
            label.setLayoutData((Object)new GridData());
        } else {
            Collections.sort(pagesNames);
            for (String pageName : pagesNames) {
                String id = pageNameToId.get(pageName);
                Link link = new Link((Composite)group, 0);
                link.setText("<a>" + pageName + "</a>");
                link.addSelectionListener((SelectionListener)new LinkSelectionListener(id));
                gd = new GridData();
                gd.horizontalIndent = 30;
                link.setLayoutData((Object)gd);
            }
        }
        Group dialogsResetGroup = new Group(composite, 0);
        dialogsResetGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        dialogsResetGroup.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        dialogsResetGroup.setText(EplMessages.GenericRootPreferencePage_dialogsGroup);
        Label label = new Label((Composite)dialogsResetGroup, 64);
        label.setText(EplMessages.GenericRootPreferencePage_clearMessagesLabelText);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).hint(this.convertVerticalDLUsToPixels(50), -1).create());
        final Button clearBt = new Button((Composite)dialogsResetGroup, 8);
        clearBt.setText(EplMessages.GenericRootPreferencePage_clearMessagesButtonLabel);
        clearBt.setLayoutData((Object)new GridData(4, 1, false, false));
        final IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.ui.epl");
        String messages = prefs.get("HiddenMessages", null);
        clearBt.setEnabled(!StringUtil.isEmpty((String)messages));
        clearBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    prefs.remove("HiddenMessages");
                    prefs.flush();
                    clearBt.setEnabled(false);
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (Throwable)ex);
                }
            }
        });
        Point point = composite.computeSize(-1, -1, true);
        gd = new GridData();
        composite.setLayoutData((Object)gd);
        gd.heightHint = point.y;
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected abstract String getPageId();

    protected String getContentsMessage() {
        return DEFAULT_MESSAGE;
    }

    private class LinkSelectionListener
    extends SelectionAdapter {
        private String pageId;

        public LinkSelectionListener(String pageId) {
            this.pageId = pageId;
        }

        public void widgetSelected(SelectionEvent e) {
            ((IWorkbenchPreferenceContainer)GenericRootPreferencePage.this.getContainer()).openPage(this.pageId, null);
        }
    }
}

